$(function() {
    var datax = new Date();
    var year = datax.getFullYear();

    $.ajax({ 
        url: "https://sal.madnezz.com.br/api/site/json/novidade.asp?tp=5&ano=" + year + "&shopping_id=" + shopping_id + "&jsoncallback=?", 
        dataType: "json" 
    }).done(function (data) {
        if (data.length) {
            $('.novidade_lista').html(''); // Limpa o carrossel antes de adicionar novos itens
            
            $.each(data.slice(0, 6), function (i, novidade) {  // Apenas 6 últimas notícias
                var imagem = novidade.novidade_imagem_1 ? 
                    'https://sal.madnezz.com.br/api/site/upload/acontece/' + novidade.novidade_imagem_1 : 
                    'https://upload.madnezz.com.br/060d19e41650e4c29d49b6b793dd4f4a';

                var descricao = novidade.novidade_texto.length > 150 ? 
                    novidade.novidade_texto.substring(0, 150) + '...' : 
                    novidade.novidade_texto;

                $('.novidade_lista').append(
                    '<li class="swiper-slide novidade_' + novidade.novidade_id + '">' +
                        '<div>' +
                            '<a href="noticias.php?noticia_id=' + novidade.novidade_id + '">' +
                                '<div class="novidade-img" style="background-image: url(' + imagem + '); background-size: cover; background-position: center;">' +
                                    '<div class="opacity-extra-medium-2 bg-transparent-gradient-arg-blue-4"></div>' +
                                '</div>' +
                            '</a>' +
                        '</div>' +
                        '<div class="info-novidade">' +
                            '<h6 class="text-white title-xx-small">' + novidade.novidade_nome + '</h6>' +
                            '<p class="text-white">' + descricao + '</p>' +
                            '<a class="text-green-argo text-large text-white-hover" href="noticias.php?noticia_id=' + novidade.novidade_id + '">Leia Mais</a>' +
                        '</div>' +
                    '</li>'
                );
            });

            // Inicializa o Swiper com as notícias carregadas
            new Swiper('.swiper-container', {
                slidesPerView: 3,
                loop: false,
                spaceBetween: 30,
                autoplay: {
                    delay: 6000,
                    disableOnInteraction: false
                },
                navigation: {
                    nextEl: '.swiper-button-next-nav',
                    prevEl: '.swiper-button-previous-nav'
                },
                keyboard: {
                    enabled: true,
                    onlyInViewport: true
                },
                breakpoints: {
                    1200: { slidesPerView: 3, spaceBetween: 20 },
                    480: { slidesPerView: 2, spaceBetween: 15 },
                    320: { slidesPerView: 1, spaceBetween: 10 }
                },
                effect: 'slide',
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true
                }
            });
        }
    });
});
